SELECT sc.name AS TABLE_SCHEMA, o.name AS TABLE_NAME,
       s.name AS STAT_OR_INDEX_NAME,
       CASE
          WHEN i.name IS NULL THEN 'statistiques'
             ELSE 'index'
          END AS OBJECT_TYPE,
       last_updated, rows, rows_sampled, steps, unfiltered_rows,
       modification_counter
FROM   sys.stats AS s
       CROSS APPLY sys.dm_db_stats_properties(s.object_id, s.stats_id) AS p
       INNER JOIN sys.objects AS o
             ON s.object_id = o.object_id
       INNER JOIN sys.schemas AS sc
             ON o.schema_id = sc.schema_id
       LEFT OUTER JOIN sys.indexes AS i
            ON s.object_id = i.object_id
               AND s.name = i.name;

--> NOTA : cette requte ne fonctionnqu' partir de la version 2008 R2 SP2. La fonction systme table sys.dm_db_stats_properties ayant t introduite  ce moment